// EWD.js Project

var constants = [];	// Yes, I know this is bad!
var auxMaps = [];	// Ditto!
var supportedApi = [];

                    // Following are for coordination across troubleshooting pages
// var controlID;
// var patientAccount;

EWD.application = {
	name: 'adt_filer',

		onMessage: {

		// ** Home Page **
          
        getVer : function(messageObj) {
            var text = messageObj.message.data[0];
			if (true) {
              document.getElementById('messageInput').value = "ADT Filer EWD.js Adaptor";
              document.getElementById('verLabel').innerHTML = '&nbsp;' + text;
            }
		},

        getMSH : function(messageObj) {
            var text = messageObj.message.data[0];
			if (!error(text)) {
              document.getElementById('mshLabel').innerHTML = '&nbsp;' + text;
            }
		},

        getComPar : function(messageObj) {
            comParTextArea.value = messageObj.message.data.join('\n');
		},
  
  		getMiscInfo : function(messageObj) {
  			document.getElementById('d1Label').innerHTML = '&nbsp;' + messageObj.message.data[0];
  			document.getElementById('d2Label').innerHTML = '&nbsp;' + messageObj.message.data[1];
  			document.getElementById('d3Label').innerHTML = '&nbsp;' + messageObj.message.data[2];
		},

		// ** Configuration Option (Application Parameter) **
          
        getApFields : function(messageObj) {
		    var text = messageObj.message.data;
		    var selectFld = document.getElementById("selectFld");
		    var i, option;

		    selectFld.options.length = 0; // Clear previous options
    
		    for (i=0; i<text.length; i++) {
		      option = document.createElement("option");
		      option.text = text[i];
		      selectFld.add(option, selectFld[i]);
		    }
	    },

        getApValues : function(messageObj) {
            // document.getElementById('apTextArea').value = '';
            // document.getElementById('messageInput').value = 'Application parameters returned!';
            document.getElementById('apTextArea').value = messageObj.message.data.join('\n');
		},
  
        checkConfiguration : function(messageObj) {
            // document.getElementById('apTextArea').value = '';
            document.getElementById('messageInput').value = 'Configuration check complete!';
            document.getElementById('apTextArea').value = messageObj.message.data.join('\n');
		},
  
        apGet1 : function(messageObj) {
            var text = messageObj.message.data[0];
			if (!error(text)) {
              document.getElementById('newApValue').value = text;
            }
		},

        apFil1 : function(messageObj) {
            var text = messageObj.message.data[0];
			if (!error(text)) {
              document.getElementById('messageInput').value = "Click 'Refresh' to display updated values!";
            }
		},

		// ** Kernel Parameter Option **
          
        getKpNames : function(messageObj) {
		    var text = messageObj.message.data;
		    var selectPar = document.getElementById("selectPar");
		    var i, option;

		    selectPar.options.length = 0; // Clear previous options
    
		    for (i=0; i<text.length; i++) {
		      option = document.createElement("option");
		      option.text = text[i];
		      selectPar.add(option, selectPar[i]);
		    }
	    },

        getKpValues : function(messageObj) {
            document.getElementById('kpTextArea').value = messageObj.message.data.join('\n');
		},
  
        setKpValue : function(messageObj) {
          var text = messageObj.message.data[0];
		  if (!error(text)) {
              document.getElementById('messageInput').value = text;
          }
		},

		// ** Translation Tables / Rules **
          
        trGetAll : function(messageObj) {
          document.getElementById('consTextArea').value = '';
          document.getElementById('consTextArea').value = messageObj.message.data.join('\n');
		},
  
        trGetNames : function(messageObj) {
		    var text = messageObj.message.data;
		    var selectTr = document.getElementById("selectCons");
		    var i, option;
            var help = 'Enter translation table values here, as INPUT^OUTPUT [Enter], INPUT^OUTPUT [Enter], etc.\n      Delete this text before creating a table (ctrl-A + delete).';

            // Simulate sendBtnConsClearEdit;
            document.getElementById('consName').value = '';
            document.getElementById('hl7Value').value = '';
            document.getElementById('copyFrom').value = '';
            document.getElementById('consOrder').value = '';
            document.getElementById("msgValue").checked = false;
            document.getElementById("emptyStr").checked = false;
            document.getElementById('consRule').value = '';
            document.getElementById('consScreen').value = '';
            document.getElementById('ioTextArea').value = help;
            document.getElementById('messageInput').value = 'Field values cleared!';
            // End 'Clear'
          
		    selectTr.options.length = 0; // Clear previous options
    
		    for (i=0; i<text.length; i++) {
		      option = document.createElement("option");
              constants[i] = piece(text[i], "^", 2);	 // Save indexed IENs
		      option.text = piece(text[i], '^', 1);
		      selectTr.add(option, selectTr[i]);
		    }
	    },
          
        trGets : function(messageObj) {
          //  document.getElementById('messageInput').value = 'GETS reply received';	//DEBUG
		  var text = messageObj.message.data;
          var i,fld,val;
          document.getElementById("ioTextArea").value = '';
          for (i=0; i<text.length; i++) {
            fld = piece(text[i], '^', 1);
            val = remainder(text[i], '^');
            if (fld == .01)
              document.getElementById("consName").value = val
            else if (fld == .05)
              document.getElementById("hl7Value").value = val
            else if (fld == .06)
              document.getElementById("copyFrom").value = val
            else if (fld == .08)
              document.getElementById("consOrder").value = val
            else if (fld == .1)	{// 'Default to' Radio Buttons
              if (val == 'EMPTY STRING') {
                document.getElementById("emptyStr").checked = true;
                document.getElementById("msgValue").checked = false;
              }
              else {
                document.getElementById("emptyStr").checked = false;
                document.getElementById("msgValue").checked = true;
              }
              continue
            }
            else if (fld == 1.5)
              document.getElementById("consRule").value = val
            else if (fld == 9)
              document.getElementById("consScreen").value = val
            else if (fld == 1)	{//	Input-Output Table
              document.getElementById("ioTextArea").value =
                document.getElementById("ioTextArea").value +
                remainder(val, '^') + '\n';
              continue
            }
            else continue;		//  No target for field #2 (description)
          }
		},

        trFil1 : function(messageObj) {
          var text = messageObj.message.data[0];
          if (!error(text))
            document.getElementById('messageInput').value = 'Data filed!';
		},
  
		//  Auxiliary Field Maps
          
        auxGetKeys : function(messageObj) {
		    var text = messageObj.message.data;
		    var selectAux = document.getElementById("auxSelect");
		    var i, option;

            // Simulate sendBtnAuxClearEdit;
            sendBtnAuxClearEdit();
            // End 'Clear'
          
		    selectAux.options.length = 0; // Clear previous options
    
		    for (i=0; i<text.length; i++) {
		      option = document.createElement("option");
              auxMaps[i] = piece(text[i], "^", 2);	 // Save indexed IENs
		      option.text = piece(text[i], '^', 1);
		      selectAux.add(option, selectAux[i]);
		    }
	    },
          
        auxGets : function(messageObj) {
          //document.getElementById('messageInput').value = 'GETS reply received';	//DEBUG
		  var text = messageObj.message.data;
          document.getElementById('messageInput').value = text[0];	//DEBUG
          if (error(text[0])) return;
          var i,j,fld,val;
          j=0; // Friend protocol sequence
          for (i=0; i<text.length; i++) {
            fld = piece(text[i], '^', 1);
            val = remainder(text[i], '^');
            if (fld == 1)
              document.getElementById("auxProtocol").value = val
            if (fld == 2)
              document.getElementById("auxSegment").value = val
            else if (fld == 3)
              document.getElementById("auxSequence").value = val
            else if (fld == 4)
              document.getElementById("auxComponent").value = val
            else if (fld == 6)
              document.getElementById("hl7DataType").value = val
            else if (fld == 15)
              document.getElementById("auxDesc").value = val
            else if (fld == 7)
              document.getElementById("fmFile").value = val
            else if (fld == 8)	
              document.getElementById("fmField").value = piece(val, ':', 1)
            else if (fld == 9)	
              document.getElementById("fmIENS").value = val
            else if (fld == 11)	
              document.getElementById("auxOrder").value = val
            else if (fld == 10.1)	
              document.getElementById("auxScreen").value = val
            else if (fld == 10)	
              document.getElementById("auxTransform").value = val
            else if (fld == 16) {
              j = piece(val, '^', 1);
              if (j < 6) {
                val = remainder(val, '^');
                if (j == 1) {
                  document.getElementById("friendProt1").value = piece(val, "^", 1);
                  document.getElementById("friendOrder1").value = piece(val, "^", 2);
                  document.getElementById("friendIENS1").value = piece(val, "^", 3);
                }

                else if (j == 2) {
                  document.getElementById("friendProt2").value = piece(val, "^", 1);
                  document.getElementById("friendOrder2").value = piece(val, "^", 2);
                  document.getElementById("friendIENS2").value = piece(val, "^", 3);
                }

                else if (j == 3) {
                  document.getElementById("friendProt3").value = piece(val, "^", 1);
                  document.getElementById("friendOrder3").value = piece(val, "^", 2);
                  document.getElementById("friendIENS3").value = piece(val, "^", 3);
                }
                
                else if (j == 4) {
                  document.getElementById("friendProt4").value = piece(val, "^", 1);
                  document.getElementById("friendOrder4").value = piece(val, "^", 2);
                  document.getElementById("friendIENS4").value = piece(val, "^", 3);
                }
                
                else if (j == 5) {
                  document.getElementById("friendProt5").value = piece(val, "^", 1);
                  document.getElementById("friendOrder5").value = piece(val, "^", 2);
                  document.getElementById("friendIENS5").value = piece(val, "^", 3);
                }
              }
            }            
            else {		//  No target for field
              continue;
                 }
          }
		},

        auxFil1 : function(messageObj) {
          var text = messageObj.message.data[0];
          if (!error(text))
            document.getElementById('messageInput').value = 'Data filed!';
		},
  
		// ** Implementation-Specific APIs **
          
        apiGetAll : function(messageObj) {
          document.getElementById('apiTextArea').value = '';
          document.getElementById('apiTextArea').value = messageObj.message.data.join('\n');
		},
  
        apiSelect : function(messageObj) {
		    var text = messageObj.message.data;
		    var selectAPI = document.getElementById("selectAPI");
		    var i, option;
            var help = 'Description';

		    selectAPI.options.length = 0; // Clear previous options
    		document.getElementById('apiXecute').value = '';
    		document.getElementById('descTextArea').value = help;
          
		    for (i=0; i<text.length; i++) {
		      option = document.createElement("option");
		      option.text = piece(text[i], '^', 1);
              supportedApi[i] = piece(text[i], "^", 2);	 // Save indexed IENs
		      selectAPI.add(option, selectAPI[i]);
		    }
	    },

        apiGets : function(messageObj) {
          //  document.getElementById('messageInput').value = 'GETS reply received';	//DEBUG
		  var text = messageObj.message.data;
          var i,fld,val;
    		document.getElementById('apiXecute').value = '';
          document.getElementById("descTextArea").value = '';
          for (i=0; i<text.length; i++) {
            fld = piece(text[i], '^', 1);
            val = remainder(text[i], '^');
            if (fld == 1)
              document.getElementById("apiXecute").value = val
            else if (fld == 2)	{	//	Description
              document.getElementById("descTextArea").value =
                document.getElementById("descTextArea").value +
                val + '\n';
              continue
            }
            else continue;			//  Ignore #.01 (Select value)
          }
		},

        apiFil1 : function(messageObj) {
          var text = messageObj.message.data[0];
          if (!error(text))
            document.getElementById('messageInput').value = 'Data filed!';
		},
  
        apiDelete : function(messageObj) {
          var text = messageObj.message.data[0];
          var help = 'Description';
          if (!error(text)) {
    		document.getElementById('apiXecute').value = '';
    		document.getElementById('descTextArea').value = help;
            document.getElementById('messageInput').value = 'Implementation-specific API deleted!';
          }
		},
  
		// ** Message Processing Summary (Option 'Trace Message Processing') **

        sumMSH : function(messageObj) {
            var text = messageObj.message.data[0];
			if (!error(text)) {
              document.getElementById('msgHdrLabel').innerHTML = '&nbsp;' + text;
            }
		},

        sumTS1 : function(messageObj) {
          document.getElementById('ts1TextArea').value = '';
          document.getElementById('ts1TextArea').value = messageObj.message.data.join('\n');
		},
  
        sumXDT : function(messageObj) {
            var text = messageObj.message.data[0];
			if (!error(text)) {
              document.getElementById('excStartDT').value = piece(text, '^', 1);
              document.getElementById('excEndDT').value = piece(text, '^', 2);
            }
            sendBtnGetExceptions();
		},

        sumXcpPr : function(messageObj) {
          var text = messageObj.message.data[0];
          if (!error(text)) {
            document.getElementById('excTextArea').value = '';
            document.getElementById('excTextArea').value = messageObj.message.data.join('\n');
          }
		},
  
        sumAccnt : function(messageObj) {
          var acct = new String(messageObj.message.data[0]);
          // patientAccount = acct.slice(0);
          document.getElementById('accntNumber').value = 'Account# ' + acct;
		},

        accntList : function(messageObj) {
          var text = messageObj.message.data[0];
          if (!error(text)) {
            document.getElementById('accountNumberTextArea').value = '';
            document.getElementById('accountNumberTextArea').value = messageObj.message.data.join('\n');
          }
		},
  
        vistaSummary : function(messageObj) {
          var text = messageObj.message.data[0];
          if (!error(text)) {
            document.getElementById('vistaSummaryTextArea').value = '';
            document.getElementById('vistaSummaryTextArea').value = messageObj.message.data.join('\n');
          }
		},
  
		// ** Performance Analysis (Statistics) **
  
        statAnal : function(messageObj) {
          var text = messageObj.message.data[0];
          if (!error(text)) {
            document.getElementById('statTextArea').value = '';
            document.getElementById('statTextArea').value = messageObj.message.data.join('\n');
          }
	    },
  
        statParm : function(messageObj) {
          var text = messageObj.message.data[0];
          if (!error(text)) {
            document.getElementById('sParTextArea').value = '';
            document.getElementById('sParTextArea').value = messageObj.message.data.join('\n');
          }
	    },
  
		// ** Footer **
  
        vistaLogin : function(messageObj) {
          var text = messageObj.message.data[0];
          if (!error(text)) {
          	document.getElementById('messageInput').value = text;
          }
        },
          
        vistaLogout : function(messageObj) {
          var text = messageObj.message.data[0];
          document.getElementById('messageInput').value = text;
        }
          
		// Insert additional reply message handlers here
    }

};

EWD.sockets.log = true; // Change to false when development is complete

EWD.onSocketsReady = function() {
  // setTimeout( sendGetVer(), 500 );
  sendGetVer();
  sendGetMSH();
  sendGetComPar();
  sendGetMisc();
}

    
//  Event handlers

$('#aboutNav').click(function() {
        loadXMLDoc("about.html","mainDiv");
        document.getElementById('messageInput').value = 'About option selected';
});

$('#configNav').click(function() {
        loadXMLDoc("ap.html","mainDiv");
        document.getElementById('messageInput').value = 'Configuration Settings option selected';
        sendBtnApRefresh();
});

$('#kpNav').click(function() {
        loadXMLDoc("kp.html","mainDiv");
        document.getElementById('messageInput').value = 'Kernel Parameters option selected';
        sendBtnKpRefresh();
});

$('#consNav').click(function() {
        loadXMLDoc("cons.html","mainDiv");
        document.getElementById('messageInput').value = 'Translation Tables option selected';
        sendBtnConsRefresh();
});

$('#auxNav').click(function() {
        loadXMLDoc("auxm.html","mainDiv");
        document.getElementById('messageInput').value = 'Auxiliary Field Maps option selected';
        sendBtnAuxRefresh();
});

$('#apiNav').click(function() {
        loadXMLDoc("api.html","mainDiv");
        document.getElementById('messageInput').value = 'Implementation-Specific APIs';
        sendBtnApiRefresh();
});

$('#sumNav').click(function() {
        loadXMLDoc("sum.html","mainDiv");
        document.getElementById('messageInput').value = 'Message Processing Summary';
});

$('#accNav').click(function() {
        loadXMLDoc("acct.html","mainDiv");
        // document.getElementById('inputAccountNumber').value = patientAccount;
});

$('#miscNav').click(function() {
        loadXMLDoc("vsum.html","mainDiv");
        // document.getElementById('vsumAccountNumber').value = patientAccount;
});

$('#statNav').click(function() {
        loadXMLDoc("stat.html","mainDiv");
});

	// Home Page

    var sendGetVer = function() {
      EWD.sockets.sendMessage({
        type: "getVer"
      });
      return;
};

    var sendGetMSH = function() {
      EWD.sockets.sendMessage({
        type: "getMSH"
      });
      return;
};

    var sendGetComPar = function() {
      EWD.sockets.sendMessage({
        type: "getComPar"
      });
      return;
};

    var sendGetMisc = function() {
      EWD.sockets.sendMessage({
        type: "getMiscInfo"
      });
      return;
};

	// ** Configuration Option (Application Parameter) **

	var sendBtnApRefresh = function() {
        sendGetApFields();
        sendGetApValues();
        document.getElementById('ApValue').value = '';
        document.getElementById('messageInput').value = 'Display was refreshed!';
};

    var sendGetApFields = function() {
      EWD.sockets.sendMessage({
        type: "getApFields"
      });
      return;
};

    var sendGetApValues = function() {
      EWD.sockets.sendMessage({
        type: "getApValues"
      });
      return;
};

    var sendBtnChkConfig = function() {
      // document.getElementById('messageInput').value = 'Checking configuration..';
      EWD.sockets.sendMessage({
        type: "checkConfiguration"
      });
      return;
};

    var sendApGet1 = function() {
      var field = document.getElementById('selectFld').value;
      EWD.sockets.sendMessage({
        type: "apGet1",
        params: {
            apField: field
        }
      });
      return;
};

    var sendBtnNewApValue = function() {
      var field = document.getElementById('selectFld').value;
      var value = document.getElementById('ApValue').value;
      EWD.sockets.sendMessage({
        type: "apFil1",
        params: {
            apField: field,
            apValue: value
          }
      });
      return;
};

	// ** Kernel Parameter Option **
          
	var sendBtnKpRefresh = function() {
        sendGetKpNames();
        sendGetKpValues();
};

    var sendGetKpNames = function() {
	  document.getElementById('messageInput').value = 'Get Kernel Parameter names';
      EWD.sockets.sendMessage({
        type: "getKpNames"
      });
      return;
};

    var sendGetKpValues = function() {
	  document.getElementById('messageInput').value = 'List Kernel Parameter Values';
      EWD.sockets.sendMessage({
        type: "getKpValues"
      });
      return;
};

    var sendBtnNewKpValue = function() {
        var pValue=document.getElementById('newValue').value;
        if (pValue == '') {
	      document.getElementById('messageInput').value = "Hint: Use '@' to delete value";
          return;
        }
        var pName = document.getElementById('selectPar').value;
        if (pName == '') {
 	      document.getElementById('messageInput').value = 'Missing parameter name!';
          return;
        }
        if (pName.indexOf('SISI ') == -1) {
          pName = 'SISI ' + pName;
        }
        document.getElementById('messageInput').value = 'Setting ' + pName + ' = ' + pValue;
        EWD.sockets.sendMessage({
          type: "setKpValue",
          params: {
            kpName: pName,
            kpValue: pValue
          }
        });
        return;
};

	// ** Translation Tables / Rules **
          
    var sendBtnConsRefresh = function() {
	  EWD.sockets.sendMessage({
        type: "trGetAll"
      });
      EWD.sockets.sendMessage({
        type: "trGetNames"
      });
      return;
};

    var sendConsGets = function() {
      document.getElementById('messageInput').value = 'Table entry selected';
      var ndx=document.getElementById("selectCons").selectedIndex;
      var ien=constants[ndx];
      EWD.sockets.sendMessage({
        type: "trGets",
        params: {
          trIEN: ien
        }
      });
      return;
};

	var sendBtnFileConsData = function() {
      var radioButton = '';
      if (document.getElementById('msgValue').checked)
        radioButton = 'MESSAGE VALUE'
      else if (document.getElementById('emptyStr').checked)
        radioButton = 'EMPTY STRING';

      var data = [];	// field^value (where value may be M code or table entry, etc.)
      var dataObject = {};
      data[0] = '.01^' + document.getElementById('consName').value;
      data[1] = '.05^' + document.getElementById('hl7Value').value;
	  data[2] = '.06^' + document.getElementById('copyFrom').value;
      data[3] = '.08^' + document.getElementById('consOrder').value;
      data[4] = '.1^' + radioButton;
      data[5] = '1.5^' + document.getElementById('consRule').value;
      data[6] = '9^' + document.getElementById('consScreen').value;
      data[7] = '1^' + document.getElementById('ioTextArea').value.split('\n');
      for (i in data) {
        dataObject[i] = data[i];
      }

      EWD.sockets.sendMessage({
        type: "trFil1",
        params: {
          trData: dataObject
        }
      });
      return;
};

	var sendBtnConsClearEdit = function() {
      document.getElementById('consName').value = '';
      document.getElementById('hl7Value').value = '';
      document.getElementById('copyFrom').value = '';
      document.getElementById('consOrder').value = '';
      document.getElementById("msgValue").checked = false;
      document.getElementById("emptyStr").checked = false;
      document.getElementById('consRule').value = '';
      document.getElementById('consScreen').value = '';
      document.getElementById('ioTextArea').value = '';
      document.getElementById('messageInput').value = 'Field values cleared!';
};

	//  Toggle Radio Buttons

    var msgValueSel = function() {
      document.getElementById("emptyStr").checked = false;
      return;
};

    var emptyStrSel = function() {
      document.getElementById("msgValue").checked = false;
      return;
};

	var clearRadioButtons = function() {
      document.getElementById("msgValue").checked = false;
      document.getElementById("emptyStr").checked = false;
};


	//  Auxiliary field maps

	var sendBtnAuxRefresh = function() {
	  document.getElementById('messageInput').value = 'Load Auxiliary Field Maps';
      EWD.sockets.sendMessage({
        type: "auxGetKeys"
      });
      return;
};

	var sendAuxSelect = function() {
      sendBtnAuxClearEdit();	//Clear form
      document.getElementById('messageInput').value = 'Auxiliary field map selected';
      var ndx=document.getElementById("auxSelect").selectedIndex;
      var ien=auxMaps[ndx];
      EWD.sockets.sendMessage({
        type: "auxGets",
        params: {
          auxIEN: ien
        }
      });
      return;
};

	var sendBtnAuxClearEdit = function() {
        document.getElementById('auxProtocol').value = '';
        document.getElementById('auxSegment').value = '';
        document.getElementById('auxSequence').value = '';
        document.getElementById('auxComponent').value = '';
        document.getElementById('hl7DataType').value = '';
        document.getElementById('auxDesc').value = '';
        document.getElementById('fmFile').value = '';
        document.getElementById('fmField').value = '';
        document.getElementById('fmIENS').value = '';
        document.getElementById('auxOrder').value = '';
        document.getElementById('auxTransform').value = '';
        document.getElementById('auxScreen').value = '';
        document.getElementById('friendProt1').value = '';
        document.getElementById('friendIENS1').value = '';
        document.getElementById('friendOrder1').value = '';
        document.getElementById('friendProt2').value = '';
        document.getElementById('friendIENS2').value = '';
        document.getElementById('friendOrder2').value = '';
        document.getElementById('friendProt3').value = '';
        document.getElementById('friendIENS3').value = '';
        document.getElementById('friendOrder3').value = '';
        document.getElementById('friendProt4').value = '';
        document.getElementById('friendIENS4').value = '';
        document.getElementById('friendOrder4').value = '';
        document.getElementById('friendProt5').value = '';
        document.getElementById('friendIENS5').value = '';
        document.getElementById('friendOrder5').value = '';
      return;
};

	var sendBtnFileAuxData = function() {
      var data = [];	// field^value or
      					// 16^friend protocol^iens^order
      var dataObject = {};
      data[0] = '1^' + document.getElementById('auxProtocol').value;
      data[1] = '2^' + document.getElementById('auxSegment').value;
	  data[2] = '3^' + document.getElementById('auxSequence').value;
      data[3] = '4^' + document.getElementById('auxComponent').value;
      data[4] = '6^' + document.getElementById('hl7DataType').value;
      data[5] = '15^' + document.getElementById('auxDesc').value;
      data[6] = '7^' + document.getElementById('fmFile').value;
      data[7] = '8^' + document.getElementById('fmField').value;
      data[8] = '9^' + document.getElementById('fmIENS').value;
      data[9] = '11^' + document.getElementById('auxOrder').value;
      data[10] = '10^' + document.getElementById('auxTransform').value;
      data[11] = '10.1^' + document.getElementById('auxScreen').value;
      var fprot;
      fprot = document.getElementById('friendProt1').value + '^' +
              document.getElementById('friendIENS1').value + '^' +
              document.getElementById('friendOrder1').value;
      data[12] = '16^'+fprot;
      fprot = document.getElementById('friendProt2').value + '^' +
              document.getElementById('friendIENS2').value + '^' +
              document.getElementById('friendOrder2').value;
      data[13] = '16^'+fprot;
      fprot = document.getElementById('friendProt3').value + '^' +
              document.getElementById('friendIENS3').value + '^' +
              document.getElementById('friendOrder3').value;
      data[14] = '16^'+fprot;
      fprot = document.getElementById('friendProt4').value + '^' +
              document.getElementById('friendIENS4').value + '^' +
              document.getElementById('friendOrder4').value;
      data[15] = '16^'+fprot;
      fprot = document.getElementById('friendProt5').value + '^' +
              document.getElementById('friendIENS5').value + '^' +
              document.getElementById('friendOrder5').value;
      data[16] = '16^'+fprot;
      for (i in data) {
        dataObject[i] = data[i];
      }

      EWD.sockets.sendMessage({
        type: "auxFil1",
        params: {
          auxData: dataObject
        }
      });
      return;
};

	// ** Implementation-specific APIs **
          
    var sendBtnApiRefresh = function() {
	  EWD.sockets.sendMessage({
        type: "apiGetAll"
      });
      EWD.sockets.sendMessage({
        type: "apiSelect"
      });
      return;
};

    var sendApiGets = function() {
      document.getElementById('messageInput').value = 'API selected';
      var ndx=document.getElementById("selectAPI").selectedIndex;
      var ien=supportedApi[ndx];
      EWD.sockets.sendMessage({
        type: "apiGets",
        params: {
          apiIEN: ien
        }
      });
      return;
};

	var sendBtnFileApiData = function() {
      var data = [];	// field^value (where value may be M code or table entry, etc.)
      var dataObject = {};
      var ndx=document.getElementById("selectAPI").selectedIndex;
      var text = document.getElementById('descTextArea').value.split('\n');
      data[0] = '.01^' + document.getElementById("selectAPI").value;
      data[1] = '1^' + document.getElementById('apiXecute').value;
      for (i = 0; i < text.length; i++) {
        data[2+i] = '2^' + text[i];
      }
      for (i in data) {
        dataObject[i] = data[i];
      }

      EWD.sockets.sendMessage({
        type: "apiFil1",
        params: {
          apiData: dataObject
        }
      });
      return;
};

	var sendBtnApiClearEdit = function() {
      document.getElementById('apiXecute').value = '';
      document.getElementById('descTextArea').value = '';
      return;
};

    var sendBtnApiDelete = function() {
      var ndx=document.getElementById("selectAPI").selectedIndex;
      var ien=supportedApi[ndx];
      EWD.sockets.sendMessage({
        type: "apiDelete",
        params: {
          apiIEN: ien
        }
      });
      return;
};

	// ** Message Processing Summary (Option 'Trace Message Processing') **

    var sendBtnGetSummary = function() {
      var messageID = document.getElementById('inputMsg').value;
      // controlID = messageID;	//For possible use elsewhere
      EWD.sockets.sendMessage({
        type: "sumMSH",
        params: {
          MID: messageID
        }
      });
      EWD.sockets.sendMessage({
        type: "sumTS1",
        params: {
          MID: messageID
        }
      });
      EWD.sockets.sendMessage({
        type: "sumXDT",
        params: {
          MID: messageID
        }
      });
      EWD.sockets.sendMessage({
        type: "sumAccnt",
        params: {
          MID: messageID
        }
      });
      return;
};

    var sendBtnGetExceptions = function() {
      var sdt=document.getElementById("excStartDT").value;
      var edt=document.getElementById("excEndDT").value;
      EWD.sockets.sendMessage({
        type: "sumXcpPr",
        params: {
          SDT: sdt,
          EDT: edt
        }
      });
      return;
};

    var sendBtnSumClearEdit = function() {
      document.getElementById("inputMsg").value = '';
      document.getElementById("accntNumber").value = '';
      document.getElementById("ts1TextArea").value = '';
      document.getElementById("msgHdrLabel").innerHTML = '&nbsp;';

      document.getElementById("excStartDT").value = '';
      document.getElementById("excEndDT").value = '';
      document.getElementById("excTextArea").value = '';
      return;
};

    var sendBtnGetAccountData = function() {
      var accnt=document.getElementById("inputAccountNumber").value;
      EWD.sockets.sendMessage({
        type: "accntList",
        params: {
          Account: accnt
        }
      });
      return;
};

	// ** VistA Patient Summary **

    var sendBtnGetVistaSummary = function() {
      var accnt=document.getElementById("vsumAccountNumber").value;
      EWD.sockets.sendMessage({
        type: "vistaSummary",
        params: {
          Account: accnt
        }
      });
      return;
};

	var sendBtnSumClearVistaSummary = function() {
      document.getElementById('vsumAccountNumber').value = '';
      document.getElementById('vistaSummaryTextArea').value = '';
      return;
};


	// ** Performance Analysis (Statistics) **

    var sendBtnGetStatistics = function() {
      var sdt=document.getElementById("statStartDT").value;
      var edt=document.getElementById("statEndDT").value;
      EWD.sockets.sendMessage({
        type: "statAnal",
        params: {
          SDT: sdt,
          EDT: edt
        }
      });
      EWD.sockets.sendMessage({
        type: "statParm"
      });
      return;
};

	// ** Footer **
          
    var sendBtnVistaLogin = function() {
      // Uncomment next to require https:
/*
      if ( !isHTTPS() ) {
        document.getElementById('messageInput').value = 'VistA login requires https: protocol.';
        return;
      }
*/
      // Login credentials (AV) is value of id="pwdInput"
      EWD.sockets.sendMessage({
        type: "vistaLogin",
        params: {
          AV: document.getElementById('pwdInput').value
          }
      });
      return;
};

    var sendBtnVistaLogout = function() {
      EWD.sockets.sendMessage({
        type: "vistaLogout"
      });
      return;
};


    // ** Utilities **

    function isHTTPS() {
      if (window.location.protocol == "https:")
        return true
      else
        return false;
};

    function error(str) {
      // If str is an error report, return TRUE and display message
      // Else, return false
          if (typeof str == 'undefined')
        str = '';
      var code = piece(str, '^', 1);
      var msg = piece(str, '^', 2);
      if (code == '-1') {
        document.getElementById('messageInput').value = msg;
        return true;
      }
      return false;
};

    var sendBtnClearMessage = function() {
      document.getElementById('messageInput').value = '';
      return;
};


// Adapted from: http://www.w3schools.com/ajax/tryit.asp?filename=tryajax_first

function loadXMLDoc(fileName,targetDiv)
{
var xmlhttp;
if (window.XMLHttpRequest)
  {// code for IE7+, Firefox, Chrome, Opera, Safari
  xmlhttp=new XMLHttpRequest();
  }
else
  {// code for IE6, IE5
  xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
  }
xmlhttp.onreadystatechange=function()
  {
  if (xmlhttp.readyState==4 && xmlhttp.status==200)
    {
    document.getElementById(targetDiv).innerHTML=xmlhttp.responseText;
    }
  }
xmlhttp.open("GET",fileName,true);
xmlhttp.send();
}

function checkPassword() {
    var hash = CryptoJS.MD5(document.getElementById('pwd').value);
    if (hash == "8d3693998e5b852bf56410c092df0fcc") return true;
    else return false;
}

function remainder(s, d) {	//One-off: All but first d[elimiter] piece of string s
    return s.slice(s.indexOf(d)+1,s.length);
}

/*
  VistA Utilities
  Author: Nikolay Topalov
  Copyright 2014 Nikolay Topalov
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at -
  https://www.apache.org/licenses/LICENSE-2.0
*/

  // simple $piece implementation
  var piece = function(str,delimiter,position) {

    if (str === undefined) return "";
    var buf = str.split(delimiter);
    return (buf[position-1] === undefined) ? "" : buf[position-1];

  };

// End VistA utilities










