//  LM - Lite IDE for EWD.js

module.exports = {

	onMessage: {

	    getProjects: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);
	        ewdtemp.$('SISOUT')._delete();
	        ewdtemp.$('SISOUT')._setDocument();

	        var str = ewd.mumps.function("PROJECTS^SISEWD0");
	        return { data: ewdtemp.$('SISOUT')._getDocument()};
	    },

	    loadNodeModule: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);
	        ewdtemp.$('SISIN')._delete();
		    ewdtemp.$('SISOUT')._delete();
	        ewdtemp.$('SISOUT')._setDocument();

		    ewdtemp.$('SISIN')._setDocument(params);
	        var str = ewd.mumps.function("PROJFILE^SISEWD");
	        return { data: ewdtemp.$('SISOUT')._getDocument()};
	    },

	    loadRoutine: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);
	      ewdtemp.$('SISIN')._delete();
	      ewdtemp.$('SISOUT')._delete();
	      ewdtemp.$('SISOUT')._setDocument();
	      ewdtemp.$('SISIN')._setDocument(params);
	      var str = ewd.mumps.function("RTN^SISEWD");
	      return { data: ewdtemp.$('SISOUT')._getDocument()};   
	    },

	    loadHTML: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);
	      ewdtemp.$('SISIN')._delete();
	      ewdtemp.$('SISOUT')._delete();
	      ewdtemp.$('SISOUT')._setDocument();
	      ewdtemp.$('SISIN')._setDocument(params);
	      var str = ewd.mumps.function("PROJFILE^SISEWD");
	      return { data: ewdtemp.$('SISOUT')._getDocument()};
	    },

	    loadApp: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);
	      ewdtemp.$('SISIN')._delete();
	      ewdtemp.$('SISOUT')._delete();
	      ewdtemp.$('SISOUT')._setDocument();
	      ewdtemp.$('SISIN')._setDocument(params);
	      var str = ewd.mumps.function("PROJFILE^SISEWD");
	      return { data: ewdtemp.$('SISOUT')._getDocument()};
	      
	    },

	    loadProjRtns: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);
	      ewdtemp.$('SISIN')._delete();
	      ewdtemp.$('SISOUT')._delete();
	      ewdtemp.$('SISOUT')._setDocument();
	      ewdtemp.$('SISIN')._setDocument(params);
	      var str = ewd.mumps.function("PROJRTNS^SISEWD0");
	      return { data: ewdtemp.$('SISOUT')._getDocument()};
	      
	    },

	    loadProjFils: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);
	      ewdtemp.$('SISIN')._delete();
	      ewdtemp.$('SISOUT')._delete();
	      ewdtemp.$('SISOUT')._setDocument();
	      ewdtemp.$('SISIN')._setDocument(params);
	      var str = ewd.mumps.function("PROJFILS^SISEWD0");
	      return { data: ewdtemp.$('SISOUT')._getDocument()};
	      
	    },

	    loadAnyFile: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);
	      ewdtemp.$('SISIN')._delete();
	      ewdtemp.$('SISOUT')._delete();
	      ewdtemp.$('SISOUT')._setDocument();
	      ewdtemp.$('SISIN')._setDocument(params);
	      var str = ewd.mumps.function("ANYFILE^SISEWD0");
	      return { data: ewdtemp.$('SISOUT')._getDocument()};
	      
	    },

	    saveIdeRoutine: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);

	      ewdtemp.$('SISIN')._delete();
	      ewdtemp.$('SISOUT')._delete();
	      ewdtemp.$('SISOUT')._setDocument();
	     
	      ewdtemp.$('SISIN')._setDocument(params);
	      var str = ewd.mumps.function("ZSAVE^SISEWD");
	      return { data: ewdtemp.$('SISOUT')._getDocument()};
	     
	    },

	    saveIdeFile: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);

	      ewdtemp.$('SISIN')._delete();
	      ewdtemp.$('SISOUT')._delete();
	      ewdtemp.$('SISOUT')._setDocument();
	     
	      ewdtemp.$('SISIN')._setDocument(params);
	      var str = ewd.mumps.function("GTF^SISEWD0");
	      return { data: ewdtemp.$('SISOUT')._getDocument()};
	     
	    },

	    newProject: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);

	      ewdtemp.$('SISIN')._delete();
	      ewdtemp.$('SISOUT')._delete();
	      ewdtemp.$('SISOUT')._setDocument();
	     
	      ewdtemp.$('SISIN')._setDocument(params);
	      var str = ewd.mumps.function("NEWPROJ^SISEWD0");
	      return { data: ewdtemp.$('SISOUT')._getDocument()};
	     
	    },

	    exportFiles: function(params, ewd) {

	      var ewdtemp = new ewd.mumps.GlobalNode('TMP',['ewd',process.pid]);

	      ewdtemp.$('SISIN')._delete();
	      ewdtemp.$('SISOUT')._delete();
	      ewdtemp.$('SISOUT')._setDocument();
	     
	      ewdtemp.$('SISIN')._setDocument(params);
	      var str = ewd.mumps.function("EXPORT^SISEWD0");
	      return { data: ewdtemp.$('SISOUT')._getDocument()};
	     
	    },

	    keepAlive: function(params, ewd) {

	      var str = ewd.mumps.function("NOP^SISEWD");
	      return;
	     
	    }

	}

};


