// LM - Lite Project Viewer/Editor

EWD.application = {
  name: 'my_IDE',


    onMessage: {
      getProjects : function(messageObj) {
    	var text = messageObj.message.data.join('\n');
    	document.getElementById('projectList').innerHTML = text;
    },

      loadNodeModule : function(messageObj) {
      var text = messageObj.message.data.join('\n');
      // Without Code Mirror, the following statement loads the text area
      // document.getElementById('nodeModuleTextArea').value = text;
      window.nodeEditor.setValue('');
      window.nodeEditor.setValue(text);
      var nodeModuleName = document.getElementById('nodeModuleName').value;
      var projectName = document.getElementById('projectName').value;
      if (piece(nodeModuleName, '.js', 1) != projectName)
        return;  // Do not load routine if node module is not THE project node module
      // Compute routine name
      var temp = piece(text,'ewd.mumps.function("',2);
          temp = piece(temp,'")',1);
      var defaultRoutine = piece(temp,'^',2);
      document.getElementById('ideRoutineName').value = defaultRoutine;
      loadRoutine();
    },

      loadRoutine : function(messageObj) {
      var text = messageObj.message.data;
      for (var i=1; i<text.length; i++) { // Delete first line routine name
        text[i-1] = text[i];
        text[i] = "";
      }
      text.length = text.length-1;        // Remove blank line from end
      // Without Code Mirror, the following statement loads the text area
      // document.getElementById('ideRoutineTextArea').value = text.join('\n');     
      // With Code Mirror, use the following -
      window.routineEditor.setValue('');
      window.routineEditor.setValue(text.join('\n'));
    },

      loadProjRtns : function(messageObj) { // Based on analogous handler in zedit
      var list = messageObj.message.data.join('\n');
      var selRoutine = document.getElementById("selRoutine");

      var option, temp;
      var n;
      var x;

      selRoutine.options.length = 0; // Clear previous routines
      temp = list.slice(0);  // Copy

      if (temp.match(/\n/g) === null) n = 1
      else n = temp.match(/\n/g).length + 1;

      for (i=0; i<n; i++) {
        x = piece(temp,'\n',i+1).slice(0);
        option = document.createElement("option");
        option.text = x;
        selRoutine.add(option, selRoutine[i]);
      }
    },

      loadProjFils : function(messageObj) { // Populate HTML or Javascript 'select' box
      var list = messageObj.message.data.join('\n');
      var option, n;

      var temp = list.slice(0);  // Copy

      if (temp.match(/\n/g) === null) n = 1
      else n = temp.match(/\n/g).length + 1;

      var selFile = document.getElementById("selHTML");
      var x = piece(temp,'\n',1).slice(0);  // First entry
      if (x.indexOf('.js') != -1) {
        selFile = document.getElementById("selJavascript");
      }

      selFile.options.length = 0; // Clear previous select list
      for (i=0; i<n; i++) {
        x = piece(temp,'\n',i+1).slice(0);
        option = document.createElement("option");
        option.text = x;
        selFile.add(option, selFile[i]);
      }
    },

      loadHTML : function(messageObj) {
      var text = messageObj.message.data.join('\n');
      // Without Code Mirror, the following statement loads the text area
      // document.getElementById('htmlTextArea').value = text;     
      // With Code Mirror, use the following -
      if( typeof(CKEDITOR) == "undefined" ) {
        window.htmlEditor.setValue('');
        window.htmlEditor.setValue(text);
      }
      else {
        //  document.getElementById('htmlTextArea').value = text;
        CKEDITOR.instances['htmlTextArea'].setData(text);
      }
    },

      loadApp : function(messageObj) {
      var text = messageObj.message.data.join('\n');
      // Without Code Mirror, the following statement loads the text area
      // document.getElementById('javascriptTextArea').value = text;
      window.appEditor.setValue('');
      window.appEditor.setValue(text);
    },

      loadAnyFile : function(messageObj) {
      var targetTextArea, text;
      var text = messageObj.message.data;
      var fileType = 0;
      // Read type from [0]
      if (text[0] == 'html') {
        targetTextArea = document.getElementById('htmlTextArea');
        fileType = 1;
      }
      else if (text[0] == 'app') {
        targetTextArea = document.getElementById('javascriptTextArea');
        fileType = 2;
      }
      // Other types here
      else return;
//    targetTextArea.value = "";      // clear before load (not working)
      for (i=1; i<text.length; i++) { // Delete file-type line (adds blank line at end)
        text[i-1] = text[i];
        text[i] = "";
      }
      text.length = text.length-1; 	  // Remove blank line from end
      // With Code Mirror, use the following -
      if (fileType == 1) {
        if( typeof(CKEDITOR) == "undefined" ) {
          window.htmlEditor.getDoc().setValue('');
          window.htmlEditor.getDoc().setValue(text.join('\n'));
        }
        else {
          // document.getElementById('htmlTextArea').value = text.join('\n');
          CKEDITOR.instances['htmlTextArea'].setData(text.join('\n'));
        }
        return;
      }
      else if (fileType == 2) {
        window.appEditor.getDoc().setValue('');
        window.appEditor.getDoc().setValue(text.join('\n'));
        return;
      }
      // Other flie types here

      // Next is deprecated -- All text areas have been converted to code mirror
      // targetTextArea.value = text.join('\n');
      return;

    },

      saveIdeRoutine : function(messageObj) {
          var text = messageObj.message.data;
          document.getElementById('messageInput').value = text[0];      
    },

      saveIdeFile : function(messageObj) {
          var text = messageObj.message.data;
          var success = text[0];
          if (success == '1') 
            document.getElementById('messageInput').value = "File saved!"
          else    
            document.getElementById('messageInput').value = "Save-to-file failed!";
          return;
    },

      newProject : function(messageObj) {
          var text = messageObj.message.data;
          document.getElementById('messageInput').value = text[0];
          if (text[0] == 'Project created!') {
            btnLoadProject();
            getProjectList();
          }
          return;      
    },

      exportFiles : function(messageObj) {
          var text = messageObj.message.data;
          document.getElementById('messageInput').value = text[0];      
    }


  }


};


EWD.sockets.log = false; // Change to false when development is complete

//  Event handlers

var getProjectList = function() {
    EWD.sockets.sendMessage({
      type: "getProjects"
    });
};

var btnLoadProject = function() {   // Main load button (default components)
    document.getElementById('ideRoutineName').value=''; // Initialize (new) routine name.
    var projectName = document.getElementById('projectName').value;
    document.getElementById('nodeModuleName').value = projectName + '.js';
    loadNodeModule();
    document.getElementById('htmlName').value = 'index.html';
    loadIndex();
    document.getElementById('javascriptName').value = 'app.js';
    loadApp();
    // Load select boxes
    loadProjRtns(); // -> Select alternate routines
    loadProjHTML(); // -> Select alternate HTML files
    loadProjJavascript(); // --> Alternate application Javascript files
    document.getElementById('messageInput').value = "  Project '" + projectName + "' load requested..";
};

    var loadNodeModule = function() {
    var nodeModuleName = document.getElementById('nodeModuleName').value;
    var projectName = document.getElementById('projectName').value;
    var useName = piece(nodeModuleName, '.js', 1);
    if (nodeModuleName == '') useName = projectName;
    EWD.sockets.sendMessage({
      type: "loadNodeModule",
      params: {
        project : useName,
           type : 'nodemod'
      }
    });
};

    var loadIndex = function() {  // To do: Replace with generic HTML file loader
    var projectName = document.getElementById('projectName').value;
    EWD.sockets.sendMessage({
      type: "loadHTML",
      params: {
        project: projectName,
        type: "index"
      }
    });
};

    var loadApp = function() {  // To do: Replace with generic Javascript file loader
    var projectName = document.getElementById('projectName').value;
    EWD.sockets.sendMessage({
      type: "loadApp",
      params: {
        project: projectName,
        type: "app"
        }
    });
};

var loadRoutine = function() {   // Called when routine name updated
    var rtnName = document.getElementById('ideRoutineName').value;
    EWD.sockets.sendMessage({
      type: "loadRoutine",
      params: {
        data: rtnName
        }
    });
};

    var loadProjRtns = function() {
    var projectName = document.getElementById('projectName').value;
    EWD.sockets.sendMessage({
      type: "loadProjRtns",
      params: {
        project: projectName
        }
    });
};

    var updateRoutineName = function() {   // Called when routine selection changed
    var rtnName = document.getElementById('selRoutine').value;
    document.getElementById('ideRoutineName').value = rtnName;
    loadRoutine();
    document.getElementById('messageInput').value = 'Routine ' + rtnName + ' load requested.';
    return;
    };

    var loadProjHTML = function() {
    var projectName = document.getElementById('projectName').value;
    EWD.sockets.sendMessage({
      type: "loadProjFils",
      params: {
        project: projectName,
        type: 'htm*'
        }
    });
};


    var updateHTMLName = function() {   // Called when HTML file selection changed
      var fileName = document.getElementById('selHTML').value;
      var projectName = document.getElementById('projectName').value;
      document.getElementById('htmlName').value = fileName;
      EWD.sockets.sendMessage({
        type: "loadAnyFile",
        params: {
          project: projectName,
          type: 'html',
          file: fileName
          }
      });
      document.getElementById('messageInput').value = 'File "' + fileName + '" load requested.';
};

    var loadProjJavascript = function() {
    var projectName = document.getElementById('projectName').value;
    EWD.sockets.sendMessage({
      type: "loadProjFils",
      params: {
        project: projectName,
        type: 'js'
        }
    });
};

    var updateJavascriptName = function() {   // Called when HTML file selection changed
      var fileName = document.getElementById('selJavascript').value;
      var projectName = document.getElementById('projectName').value;
      document.getElementById('javascriptName').value = fileName;
      EWD.sockets.sendMessage({
        type: "loadAnyFile",
        params: {
          project: projectName,
          type: 'app',
          file: fileName
          }
      });
      document.getElementById('messageInput').value = 'File "' + fileName + '" load requested.';
};

//  **  Individual load buttons for each application component - Remove redundant code later  **

    var sendBtnLoadNodeModule = function() {
      var nodeModuleName = document.getElementById('nodeModuleName').value;
      loadNodeModule();
      document.getElementById('messageInput').value = 'Node module "' + nodeModuleName + '" load requested.';
      return;
};

    var sendBtnLoadIdeRoutine = function() {
      var rtnName = document.getElementById('ideRoutineName').value;
      loadRoutine();
      document.getElementById('messageInput').value = 'Routine ' + rtnName + ' load requested.';
      return;
};

    var sendBtnLoadHTML = function() {  // Much redundancy with updateHTMLName
      var fileName = document.getElementById('htmlName').value;
      var projectName = document.getElementById('projectName').value;
      EWD.sockets.sendMessage({
        type: "loadAnyFile",
        params: {
          project: projectName,
          type: 'html',
          file: fileName
          }
      });
      document.getElementById('messageInput').value = 'File "' + fileName + '" load requested.';
      return;
};

    var copyComponentToClipboard = function() {
      var comp = document.getElementById('selComponent').value;
      if (comp == 'Copy') return; // Not a component
      document.getElementById('messageInput').value = 'Request copy -' + comp + '- to clipboard.'
      // Coding in progress here
      return;
};



    var sendBtnLoadJavascript = function() {  // Much redundancy with updateJavascriptName
      var fileName = document.getElementById('javascriptName').value;
      var projectName = document.getElementById('projectName').value;
      EWD.sockets.sendMessage({
        type: "loadAnyFile",
        params: {
          project: projectName,
          type: 'app',
          file: fileName
          }
      });
      document.getElementById('messageInput').value = 'File "' + fileName + '" load requested.';
      return;
};

//  **  Individual save buttons for each application component - Remove redundant code later  **
//  **                          Save functions are password protected                         **

    var sendBtnSaveNodeModule = function() {
      if (!checkPassword()) {
        document.getElementById('messageInput').value = 'Invalid Password';
        return;
      }
      var projectName = document.getElementById('projectName').value;
      var nodeModuleName = document.getElementById('nodeModuleName').value;
      EWD.sockets.sendMessage({
        type: "saveIdeFile",
        params: {
          project: projectName,
          type: 'nodemod',
          file: nodeModuleName,
      //  Next is deprecated - Text area replaced by code mirror      
      //  data: document.getElementById('nodeModuleTextArea').value.split('\n')
          data: window.nodeEditor.getDoc().getValue().split('\n')
         }
      });
      return;
};

    var sendBtnSaveIdeRoutine = function() {
      var rtnName = document.getElementById('ideRoutineName').value;
      if (!checkPassword()) {
          document.getElementById('messageInput').value = 'Invalid Password';
          return;
        }
      ;   //  Call save here
      document.getElementById('messageInput').value = '';
      EWD.sockets.sendMessage({
        type: "saveIdeRoutine",
        params: {
            rn: rtnName,
      //  Next is deprecated - Text area replaced by code mirror      
      //  data: document.getElementById('ideRoutineTextArea').value.split('\n')
          data: window.routineEditor.getDoc().getValue().split('\n')
          }
      });
//    document.getElementById('messageInput').value = 'Routine ' + rtnName + ' save requested.';
      return;
};

    var sendBtnSaveHTML = function() {
      if (!checkPassword()) {
          document.getElementById('messageInput').value = 'Invalid Password';
          return;
        }
      var projectName = document.getElementById('projectName').value;
      var htmlName = document.getElementById('htmlName').value;
	  var text;
      if( typeof(CKEDITOR) == "undefined" ) {  // Code mirror
        text = window.htmlEditor.getDoc().getValue().split('\n');
      }
	  else {  // ckEditor or plain text area
        text = CKEDITOR.instances['htmlTextArea'].getData().split('\n');
      }
      EWD.sockets.sendMessage({
        type: "saveIdeFile",
        params: {
          project: projectName,
          type: 'app',
          file: htmlName,
          data: text
          }
      });
      return;
};

    var sendBtnSaveJavascript = function() {
      if (!checkPassword()) {
          document.getElementById('messageInput').value = 'Invalid Password';
          return;
        }
      var projectName = document.getElementById('projectName').value;
      var javascriptName = document.getElementById('javascriptName').value;
      EWD.sockets.sendMessage({
        type: "saveIdeFile",
        params: {
          project: projectName,
          type: 'app',
          file: javascriptName,
      //  Next is deprecated - Text area replaced by code mirror      
      //  data: document.getElementById('javascriptTextArea').value.split('\n')
          data: window.appEditor.getDoc().getValue().split('\n')
          }
      });
      return;
};

//    ** SAVE PROJECT ** //

    var sendBtnSaveProject = function() {   // 'Save All' button
      if (!checkPassword()) { // No need to check four times!
          document.getElementById('messageInput').value = 'Invalid Password';
          return;
        }
      if (document.getElementById('htmlName').value != '')
        sendBtnSaveHTML();
      if (document.getElementById('javascriptName').value != '')
        sendBtnSaveJavascript();
      if (document.getElementById('nodeModuleName').value != '')
        sendBtnSaveNodeModule();
      if (document.getElementById('ideRoutineName').value != '')
        sendBtnSaveRoutine();
      return;
};

//    ** NEW and EXPORT buttons ** //

    var sendBtnNewProject = function() {   // 'New' button
      if (!checkPassword()) {
          document.getElementById('messageInput').value = 'Invalid Password';
          return;
        }
      var projectName = document.getElementById('projectName').value;
      if (projectName.indexOf(' ') >= 0) {
           document.getElementById('messageInput').value = 'Invalid project name: <space> not allowed';
           return;
      }
      var projectName = document.getElementById('projectName').value;
      EWD.sockets.sendMessage({
        type: "newProject",
        params: {
          project: projectName
          }
      });
      return;
};

    var sendBtnExportArchive = function() {   // 'Export' button
      if (!checkPassword()) {
          document.getElementById('messageInput').value = 'Invalid Password';
          return;
        }
      var parm = document.getElementById('projectName').value + '^';
      parm = parm + document.getElementById('nodeModuleName').value + '^';
      parm = parm + document.getElementById('ideRoutineName').value + '^';
      parm = parm + document.getElementById('htmlName').value + '^';
      parm = parm + document.getElementById('javascriptName').value;
      EWD.sockets.sendMessage({
        type: "exportFiles",
        params: {
          files: parm
          }
      });
      return;
};



//    ** Miscellaneous event handlers ** //

    var sendBtnPreviewProject = function() {
      var url = self.location.toString();
      var adr = piece(url, '/ewd/', 1);
      var projectName = document.getElementById('projectName').value;
      if (projectName == '') {
        document.getElementById('messageInput').value = 'Nothing to preview.. Please specify a project name.';
        return;
      }
      var htmlName = document.getElementById('htmlName').value;
      if (htmlName == '') {
        document.getElementById('messageInput').value = 'Nothing to preview.. Please load an html page.';
        return;
      }
      url = adr + '/ewd/' + projectName + '/' + htmlName;
      document.getElementById('messageInput').value = 'Preview - ' + url;
      window.location = url;  // .replace does not preserve back button history
      return;
};

    var sendBtnClearMessage = function() {
      document.getElementById('messageInput').value = '';
      return;
};

    var sendKeepAlive = function() {   // Every 5 minutes
        EWD.sockets.sendMessage({
          type: "keepAlive"
        });
};

/*
  VistA Utilities
  Author: Nikolay Topalov
  Copyright 2014 Nikolay Topalov
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
*/

  // simple $piece implementation
  var piece = function(str,delimiter,position) {
    
    if (str === undefined) return "";
    var buf = str.split(delimiter);
    return (buf[position-1] === undefined) ? "" : buf[position-1]; 
    
  };

// End VistA utilities

// Utilities

    function checkPassword() {
    var hash = CryptoJS.MD5(document.getElementById('pwd').value);
    if (hash == "8d3693998e5b852bf56410c092df0fcc") return true;
    else return false;
    }

// End utilities


